@extends('admin.dash_layouts.main')
@section('title')
    {{ 'Dashboard page' }}
@endsection
@section('content')
    <!-- ============================================================== -->
    <!-- Start right Content here -->
    <!-- ============================================================== -->
    <div class="content-page">
        <!-- Start content -->
        <div class="content">

            <div class="container-fluid">
                <div class="page-title-box">

                    <div class="row align-items-center ">
                        <div class="col-md-8">
                            <div class="page-title-box">
                                <h4 class="page-title">Tour Sales Manage</h4>
                                <ol class="breadcrumb">
                                    <li class="breadcrumb-item">
                                        <a href="#">Dashboard</a>
                                    </li>
                                    <li class="breadcrumb-item">
                                        <a href="#">Tour Sales</a>
                                    </li>
                                    <li class="breadcrumb-item active">Add Tour Sales</li>
                                </ol>
                            </div>
                        </div>

                    </div>
                </div>
                <!-- end page-title -->

                @if (session()->has('success'))
                    <div class="alert alert-success alert-dismissible fade show" role="alert">
                        <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                            <span aria-hidden="true">×</span>
                        </button>
                        {{ session()->get('success') }}
                    </div>
                @endif

                <div class="row">
                    <div class="col-12">
                        <div class="card">
                            <div class="card-body">
                                <form action="/finished-tour" enctype="multipart/form-data" method="post">
                                    @csrf
                                    <div class="form-group ">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Name</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" readonly value="{{ $data->name }}"
                                                name="name" required>
                                            <input class="form-control" type="hidden" value="{{ $data->id }}"
                                                name="clientid" required>
                                        </div>
                                    </div>


                                    <h4 class="mt-0 header-title"> Tour Sales</h4>
                                    <div class="row">
                                        <div class="dynamic-table">
                                            <table class="table table-bordered responsive" id="dynamic-table">
                                                <thead>
                                                    <tr>
                                                        <th>Column 1</th>
                                                        <th>Column 2</th>
                                                        <th>Column 3</th>
                                                        <th>Column 4</th>
                                                        <th>Action</th>
                                                    </tr>
                                                </thead>
                                                <tbody>
                                                    <tr>
                                                        <td><input class="form-control " type="Date" name="date[0]">
                                                            <input type="hidden" name="day[0]" value="1">
                                                        </td>

                                                        <td> Name<input class="form-control " type="text"
                                                                name="hotel[0] ">
                                                            <br> Contact <input class="form-control " type="text"
                                                                name="h-contact[0] "><br> Address <input
                                                                class="form-control " type="text" name="h-address[0] ">
                                                            <br> price<input class="form-control " type="text"
                                                                name="h-price[0] "> <br>
                                                            <br> Note<input class="form-control " type="text"
                                                                name="h-note[0] "> <br>
                                                        </td>
                                                        <td><input type="text" class="form-control pac-target-input"
                                                                name="destination[]" placeholder="Destination 1"
                                                                autocomplete="off"></td>
                                                        <td><input class="form-control " type="text" name="spec[0]"></td>
                                                    </tr>
                                                </tbody>
                                            </table>
                                            <button id="add-row">Add Row</button>
                                            <button class="btn btn-primary add-destination">Add Destination</button>
                                        </div>
                                    </div>
                                    <div class="form-group ">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Package</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" placeholder=" " name="package">
                                        </div>
                                    </div>
                                    <div class="form-group ">
                                        <label for="example-text-input" class="col-sm-2 col-form-label">Price</label>
                                        <div class="col-sm-10">
                                            <input class="form-control" type="text" placeholder=" " name="price">
                                        </div>
                                    </div>

                                    <div class="form-group mb-0">
                                        <div>
                                            <button type="submit" class="btn btn-primary waves-effect waves-light">
                                                Submit
                                            </button>
                                            <button type="reset" class="btn btn-secondary waves-effect m-l-5">
                                                Cancel
                                            </button>
                                        </div>
                                </form>
                            </div>
                        </div>
                    </div>
                    <!-- end col -->
                </div>

            </div>
            <!-- container-fluid -->

        </div>
        <!-- content -->

    </div>
    <script src="https://code.jquery.com/jquery-3.6.0.min.js"></script>
    <script>
    $(document).ready(function() {
        var i = 0; // Initialize i to 0
        var d = 1;
        // Add Row button click event
        $('#add-row').click(function() {
            event.preventDefault()
            // Create a new row
            i++;
            d++;
            var newRow = $('<tr>');

            // Add input fields to the row
            newRow.append('<td><input class="form-control" type="date" name="date[' + i +
                ']">  <input type="text" name="day[' + i + ']" value="' + d +
                '"></td>');
            newRow.append('<td>Name <input class="form-control" type="text" name="hotel[' + i +
                ']"> <br> Contact <input class="form-control" type="text" name="h-contact[' + i +
                ']"><br> Address <input class="form-control" type="text" name="h-address[' + i +
                ']"><br> price <input class="form-control" type="text" name="h-price[' + i +
                ']"><br> Note <input class="form-control" type="text" name="h-note[' + i +
                ']"> </td>');
            newRow.append(
                '<td><input class="form-control pac-target-input" type="text" name="destination[' + i + ']" placeholder="Destination" autocomplete="off"></td>'
            );
            newRow.append('<td><input class="form-control" type="text" name="spec[' + i +
                ']"></td>');
            newRow.append('<td><button class="delete-row">Delete</button></td>');

            // Append the new row to the table body
            $('#dynamic-table tbody').append(newRow);
            event.preventDefault()
            // Initialize Google Places Autocomplete for the new destination input field
            var destinationInput = newRow.find('.pac-target-input');
            new google.maps.places.Autocomplete(destinationInput[0], {
                componentRestrictions: {
                    country: 'LK'
                } // 'LK' is the country code for Sri Lanka
            });
        });

        // Delete row button click event
        $('#dynamic-table').on('click', '.delete-row', function() {
            event.preventDefault()
            $(this).closest('tr').remove();
        });

        // Add Destination button click event
        $('.add-destination').click(function() {
            // Find the last row in the table
            event.preventDefault()
            var lastRow = $('#dynamic-table tbody tr:last');

            // Add a new destination input field to the last row
            lastRow.find('td:eq(2)').append(
                '<input class="form-control pac-target-input" type="text" name="destination[' + i + ']" placeholder="Destination" autocomplete="off">'
            );

            // Initialize Google Places Autocomplete for the new destination input field
            var destinationInput = lastRow.find('.pac-target-input:last');
            new google.maps.places.Autocomplete(destinationInput[0], {
                componentRestrictions: {
                    country: 'LK'
                } // 'LK' is the country code for Sri Lanka
            });
        });

        // Initialize Google Places Autocomplete for the first destination input field
        var destinationInput = document.querySelector('.pac-target-input');
        new google.maps.places.Autocomplete(destinationInput, {
            componentRestrictions: {
                country: 'LK'
            } // 'LK' is the country code for Sri Lanka
        });
    });
</script>

@endsection
